# Intuition
<!-- Describe your first thoughts on how to solve this problem. -->
Unitarily transfering wine from top-most glass to child glasses.

# Approach
<!-- Describe your approach to solving the problem. -->
- Kept a 2D matrix to store the champagne tower visualisation
- Put all wine to topmost glass : then keep transfering to child glasses
- Until the upper glass have more than 1 pour wine, transfer extra to its two children lower glasses
- In case if that glass have more than 1 pour : then return 1 : cause we haven't transferred it yet to its children 
---
Have a look at the code , still have any confusion then please let me know in the comments
Keep Solving.:)

# Complexity
- Time complexity : $$O((query_-row)^2)$$
<!-- Add your time complexity here, e.g. $$O(n)$$ -->

- Space complexity : $$O((query_-row)^2)$$
<!-- Add your space complexity here, e.g. $$O(n)$$ -->

# Code
```
class Solution {
    public double champagneTower(int poured, int query_row, int query_glass) {
        double[][] g = new double[query_row+1][query_row+1];
        g[0][0] = poured;                      // put all wine to topmost glass : then keep transfering to child glasses
        for( int i = 0; i < query_row; i++){
            for( int j = 0; j <= i; j++){
                if(g[i][j] > 1){                   // until the upper glass have more than 1 pour wine, transfer extra to its two children lower glasses
                    g[i+1][j] += (g[i][j] - 1)/2.0;
                    g[i+1][j+1] += (g[i][j] - 1)/2.0;
                }
            }
        }
        return Math.min(1.0, g[query_row][query_glass]); // in case if that glass have more than 1 pour : then return 1 : cause we haven't transferred it yet to its children : 

    }
}
```